package gov.va.med.mhv.phr.chemlabs.model;

import org.displaytag.decorator.TableDecorator;

/**
 * Defines the order in which Chem Labs summary page is ordered.
 * @author                   
 */
public class ChemLabsRowSorter extends MultiPropertyRowSorter {

    private static final SortOrder[] SORT_ORDER = {
        new SortOrder("collectedOn", false),
        new SortOrder("specimen", true),
        new SortOrder("orderingLocation", true)
    };

    public ChemLabsRowSorter(String propertyName, TableDecorator tableDecorator,
        boolean isAscending)
    {
        super(propertyName, tableDecorator, isAscending);
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.model.MultiplePropertySorter#getSortOrder()
     */
    @Override
    protected SortOrder[] getSortOrder()
    {
        return SORT_ORDER;
    }

}
